#!/usr/bin/env python

"""
Set value of MS option in kernel Image

Usage: ms_bin_option_update_int.py OUTPUT OPTION_NAME VALUE
"""

import os
import sys
import mmap
import struct

if sys.version_info.major >= 3:
    long = int

if __name__ == '__main__':

    name = sys.argv[2].encode("utf-8")
    if sys.argv[3].upper().startswith('0X'):
        value = long(sys.argv[3], 16)
    else:
        value = long(sys.argv[3])

    fmap = mmap.mmap(os.open(sys.argv[1], os.O_RDWR), 0)
    try:
        offset = fmap.find(name)
        if offset < 0:
            raise ValueError(
                'ms_bin_option:%s not found in %s\n' % (name, sys.argv[1]))

        fmap.seek(offset + 8, os.SEEK_SET)
        fmap.write(struct.pack('<I', value))
    finally:
        fmap.close()
